/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.jabsorb.serializer;

import com.liferay.petra.lang.ClassLoaderPool;
import com.liferay.portal.json.jabsorb.serializer.LiferaySerializerState;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONObject;

public class LiferayJSONSerializer
extends JSONSerializer {
    private static final Log _log = LogFactoryUtil.getLog(LiferayJSONSerializer.class);

    public ObjectMatch tryUnmarshall(SerializerState serializerState, Class clazz, Object jsonObj) throws UnmarshallException {
        if (!(serializerState instanceof LiferaySerializerState)) {
            serializerState = new LiferaySerializerState();
        }
        return super.tryUnmarshall(serializerState, clazz, jsonObj);
    }

    public Object unmarshall(SerializerState serializerState, Class clazz, Object jsonObj) throws UnmarshallException {
        if (!(serializerState instanceof LiferaySerializerState)) {
            serializerState = new LiferaySerializerState();
        }
        return super.unmarshall(serializerState, clazz, jsonObj);
    }

    protected Class getClassFromHint(Object object) throws UnmarshallException {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            String className = "";
            try {
                JSONObject jsonObject = (JSONObject)object;
                className = jsonObject.getString("javaClass");
                if (jsonObject.has("contextName")) {
                    String contextName = jsonObject.getString("contextName");
                    ClassLoader classLoader = ClassLoaderPool.getClassLoader((String)contextName);
                    if (classLoader != null) {
                        return Class.forName(className, true, classLoader);
                    }
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)StringBundler.concat((String[])new String[]{"Unable to get class loader for class ", className, " in context ", contextName}));
                    }
                }
            }
            catch (Exception e) {
                throw new UnmarshallException("Unable to get class " + className, (Throwable)e);
            }
        }
        return super.getClassFromHint(object);
    }
}

