/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.source.formatter.BaseSourceProcessor;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.checks.util.JSPSourceUtil;
import com.liferay.source.formatter.checkstyle.util.AlloyMVCCheckstyleLogger;
import com.liferay.source.formatter.checkstyle.util.AlloyMVCCheckstyleUtil;
import com.liferay.source.formatter.checkstyle.util.CheckstyleUtil;
import com.liferay.source.formatter.util.SourceFormatterUtil;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JSPSourceProcessor
extends BaseSourceProcessor {
    private static final String[] _INCLUDES = new String[]{"**/*.jsp", "**/*.jspf", "**/*.tag", "**/*.tpl", "**/*.vm"};
    private AlloyMVCCheckstyleLogger _checkstyleLogger;
    private Configuration _configuration;
    private final Set<SourceFormatterMessage> _sourceFormatterMessages = new HashSet<SourceFormatterMessage>();
    private final List<File> _ungeneratedFiles = new ArrayList<File>();

    @Override
    protected List<String> doGetFileNames() throws Exception {
        String[] excludes = new String[]{"**/null.jsp", "**/tools/**"};
        List<String> fileNames = this.getFileNames(excludes, this.getIncludes());
        if (fileNames.isEmpty() || !this.sourceFormatterArgs.isFormatCurrentBranch() && !this.sourceFormatterArgs.isFormatLatestAuthor() && !this.sourceFormatterArgs.isFormatLocalChanges()) {
            return fileNames;
        }
        List<String> allJSPFileNames = this.getFileNames(excludes, this.getIncludes(), true);
        return JSPSourceUtil.addIncludedAndReferencedFileNames(fileNames, new HashSet<String>(), JSPSourceUtil.getContentsMap(allJSPFileNames));
    }

    @Override
    protected String[] doGetIncludes() {
        return _INCLUDES;
    }

    @Override
    protected File format(File file, String fileName, String absolutePath, String content) throws Exception {
        List<String> fileNames;
        if ((this.sourceFormatterArgs.isFormatCurrentBranch() || this.sourceFormatterArgs.isFormatLatestAuthor() || this.sourceFormatterArgs.isFormatLocalChanges()) && (fileNames = SourceFormatterUtil.filterFileNames(Arrays.asList(fileName), new String[0], new String[]{"*.*"}, this.getSourceFormatterExcludes(), false)).isEmpty()) {
            return file;
        }
        file = super.format(file, fileName, absolutePath, content);
        this._processCheckstyle(absolutePath, content);
        return file;
    }

    @Override
    protected void postFormat() throws Exception {
        this._processCheckstyle();
        for (SourceFormatterMessage sourceFormatterMessage : this._sourceFormatterMessages) {
            String fileName = sourceFormatterMessage.getFileName();
            this.processMessage(fileName, sourceFormatterMessage);
            this.printError(fileName, sourceFormatterMessage.toString());
        }
    }

    private void _processCheckstyle() throws Exception {
        if (this._ungeneratedFiles.isEmpty()) {
            return;
        }
        if (this._configuration == null) {
            this._checkstyleLogger = new AlloyMVCCheckstyleLogger(new UnsyncByteArrayOutputStream(), true, this.sourceFormatterArgs.getBaseDirName());
            this._configuration = CheckstyleUtil.getConfiguration("checkstyle-alloy-mvc.xml", this.getPropertiesMap(), this.sourceFormatterArgs.getMaxLineLength(), this.sourceFormatterArgs.isShowDebugInformation());
        }
        this._sourceFormatterMessages.addAll(this.processCheckstyle(this._configuration, this._checkstyleLogger, this._ungeneratedFiles.toArray(new File[this._ungeneratedFiles.size()])));
        for (File ungeneratedFile : this._ungeneratedFiles) {
            Files.deleteIfExists(ungeneratedFile.toPath());
        }
        this._ungeneratedFiles.clear();
    }

    private synchronized void _processCheckstyle(String absolutePath, String content) throws Exception {
        File file = AlloyMVCCheckstyleUtil.getJavaFile(absolutePath, content);
        if (file != null) {
            this._ungeneratedFiles.add(file);
            if (this._ungeneratedFiles.size() == 1000) {
                this._processCheckstyle();
            }
        }
    }
}

