/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.parser;

import com.liferay.portal.kernel.util.StringUtil;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Hugo Huijser
 */
public class JavaClass extends BaseJavaTerm {

	public JavaClass(
		String name, String content, String accessModifier, boolean isStatic) {

		super(name, content, accessModifier, isStatic);
	}

	public void addChildJavaTerm(JavaTerm javaTerm) {
		javaTerm.setParentJavaClass(this);

		_childJavaTerms.add(javaTerm);
	}

	public void addExtendedClassNames(String... extendedClassNames) {
		for (String extendedClassName : extendedClassNames) {
			_extendedClassNames.add(StringUtil.trim(extendedClassName));
		}
	}

	public void addImplementedClassNames(String... implementedClassNames) {
		for (String implementedClassName : implementedClassNames) {
			_implementedClassNames.add(StringUtil.trim(implementedClassName));
		}
	}

	public void addImport(String importName) {
		_imports.add(importName);
	}

	public List<JavaTerm> getChildJavaTerms() {
		return _childJavaTerms;
	}

	public List<String> getExtendedClassNames() {
		return _extendedClassNames;
	}

	public List<String> getImplementedClassNames() {
		return _implementedClassNames;
	}

	public List<String> getImports() {
		return _imports;
	}

	public String getPackageName() {
		return _packageName;
	}

	public void setPackageName(String packageName) {
		_packageName = packageName;
	}

	private final List<JavaTerm> _childJavaTerms = new ArrayList<>();
	private List<String> _extendedClassNames = new ArrayList<>();
	private List<String> _implementedClassNames = new ArrayList<>();
	private List<String> _imports = new ArrayList<>();
	private String _packageName;

}