/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtility;

/**
 * @author Hugo Huijser
 */
public class SubnameCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {
			TokenTypes.METHOD_DEF, TokenTypes.PARAMETER_DEF,
			TokenTypes.VARIABLE_DEF
		};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST nameAST = detailAST.findFirstToken(TokenTypes.IDENT);

		String name = nameAST.getText();

		if (detailAST.getType() == TokenTypes.METHOD_DEF) {
			if (name.matches("(^_?sub|.*Sub)[A-Z].*") &&
				!AnnotationUtility.containsAnnotation(detailAST, "Override")) {

				log(detailAST.getLineNo(), _MSG_METHOD_INVALID_NAME, name);
			}
		}
		else if (name.matches("^_?sub[A-Z].*")) {
			if (detailAST.getType() == TokenTypes.PARAMETER_DEF) {
				log(detailAST.getLineNo(), _MSG_PARAMETER_INVALID_NAME, name);
			}
			else {
				log(detailAST.getLineNo(), _MSG_VARIABLE_INVALID_NAME, name);
			}
		}
	}

	private static final String _MSG_METHOD_INVALID_NAME = "method.invalidName";

	private static final String _MSG_PARAMETER_INVALID_NAME =
		"parameter.invalidName";

	private static final String _MSG_VARIABLE_INVALID_NAME =
		"variable.invalidName";

}