/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

/**
 * @author Hugo Huijser
 */
public class SemiColonCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.SEMI};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST previousSiblingAST = detailAST.getPreviousSibling();

		if (previousSiblingAST == null) {
			return;
		}

		if ((previousSiblingAST.getType() == TokenTypes.CLASS_DEF) ||
			(previousSiblingAST.getType() == TokenTypes.CTOR_DEF) ||
			(previousSiblingAST.getType() == TokenTypes.ENUM_DEF) ||
			(previousSiblingAST.getType() == TokenTypes.INTERFACE_DEF) ||
			(previousSiblingAST.getType() == TokenTypes.METHOD_DEF)) {

			log(detailAST.getLineNo(), _MSG_UNNECESSARY_SEMI_COLON);
		}
		else if (previousSiblingAST.getType() == TokenTypes.ENUM_CONSTANT_DEF) {
			DetailAST nextSiblingAST = detailAST.getNextSibling();

			if ((nextSiblingAST != null) &&
				(nextSiblingAST.getType() == TokenTypes.RCURLY)) {

				log(detailAST.getLineNo(), _MSG_UNNECESSARY_SEMI_COLON);
			}
		}
	}

	private static final String _MSG_UNNECESSARY_SEMI_COLON =
		"semi.colon.unnecessary";

}