/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

/**
 * @author Hugo Huijser
 */
public class LineEndCharacterCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {
			TokenTypes.GENERIC_START, TokenTypes.LPAREN, TokenTypes.TYPECAST
		};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		if (detailAST.getType() == TokenTypes.LPAREN) {
			DetailAST parentAST = detailAST.getParent();

			if ((parentAST.getType() == TokenTypes.ANNOTATION) ||
				(parentAST.getType() == TokenTypes.CTOR_CALL) ||
				(parentAST.getType() == TokenTypes.CTOR_DEF) ||
				(parentAST.getType() == TokenTypes.ENUM_CONSTANT_DEF) ||
				(parentAST.getType() == TokenTypes.LAMBDA) ||
				(parentAST.getType() == TokenTypes.LITERAL_CATCH) ||
				(parentAST.getType() == TokenTypes.LITERAL_NEW) ||
				(parentAST.getType() == TokenTypes.METHOD_DEF) ||
				(parentAST.getType() == TokenTypes.SUPER_CTOR_CALL)) {

				return;
			}
		}

		if (_isAtLineEnd(detailAST)) {
			log(
				detailAST.getLineNo(), _MSG_INCORRECT_END_LINE_CHARACTER,
				detailAST.getText());
		}
	}

	private boolean _isAtLineEnd(DetailAST detailAST) {
		String line = getLine(detailAST.getLineNo() - 1);

		String text = detailAST.getText();

		if (line.endsWith(text) &&
			((detailAST.getColumnNo() + text.length()) == line.length())) {

			return true;
		}

		return false;
	}

	private static final String _MSG_INCORRECT_END_LINE_CHARACTER =
		"end.line.character.incorrect";

}