/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

/**
 * @author Hugo Huijser
 */
public class EnumConstantOrderCheck extends BaseEnumConstantCheck {

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST nextEnumConstantDefAST = getNextEnumConstantDefAST(detailAST);

		if (nextEnumConstantDefAST != null) {
			_checkOrder(detailAST, nextEnumConstantDefAST);
		}
	}

	private void _checkOrder(
		DetailAST enumConstantDefAST1, DetailAST enumConstantDefAST2) {

		NaturalOrderStringComparator comparator =
			new NaturalOrderStringComparator();

		String name1 = _getName(enumConstantDefAST1);
		String name2 = _getName(enumConstantDefAST2);

		if (comparator.compare(name1, name2) > 0) {
			log(
				enumConstantDefAST1.getLineNo(),
				_MSG_ENUM_CONSTANT_ORDER_INCORRECT, name1, name2);
		}
	}

	private String _getName(DetailAST enumConstantDefAST) {
		DetailAST nameAST = enumConstantDefAST.findFirstToken(TokenTypes.IDENT);

		return nameAST.getText();
	}

	private static final String _MSG_ENUM_CONSTANT_ORDER_INCORRECT =
		"enum.constant.incorrect.order";

}