/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;

import com.puppycrawl.tools.checkstyle.api.DetailAST;

/**
 * @author Hugo Huijser
 */
public class EnumConstantDividerCheck extends BaseEnumConstantCheck {

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST nextEnumConstantDefAST = getNextEnumConstantDefAST(detailAST);

		if (nextEnumConstantDefAST != null) {
			_checkDivider(detailAST, nextEnumConstantDefAST);
		}
	}

	private void _checkDivider(
		DetailAST enumConstantDefAST1, DetailAST enumConstantDefAST2) {

		int endLineConstant1 = DetailASTUtil.getEndLine(enumConstantDefAST1);
		int startLineConstant2 = DetailASTUtil.getStartLine(
			enumConstantDefAST2);

		if (endLineConstant1 == startLineConstant2) {
			return;
		}

		String nextLine = getLine(endLineConstant1);
		String nextNextLine = StringUtil.trim(getLine(endLineConstant1 + 1));

		if (Validator.isNull(nextLine) && !nextNextLine.startsWith("/")) {
			log(endLineConstant1 + 1, _MSG_UNNECESSARY_EMPTY_LINE);
		}
	}

	private static final String _MSG_UNNECESSARY_EMPTY_LINE =
		"empty.line.unnecessary";

}