/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Hugo Huijser
 */
public class SourceCheckConfiguration {

	public SourceCheckConfiguration(String name) {
		_name = name;
	}

	public void addAttribute(String name, String value) {
		List<String> attributeValues = _attributesMap.get(name);

		if (attributeValues == null) {
			attributeValues = new ArrayList<>();
		}

		attributeValues.add(value);

		_attributesMap.put(name, attributeValues);
	}

	public Set<String> attributeNames() {
		return _attributesMap.keySet();
	}

	public List<String> getAttributeValues(String name) {
		return _attributesMap.get(name);
	}

	public String getName() {
		return _name;
	}

	public boolean isEnabled() {
		return _enabled;
	}

	public void setEnabled(boolean enabled) {
		_enabled = enabled;
	}

	private final Map<String, List<String>> _attributesMap = new HashMap<>();
	private boolean _enabled;
	private final String _name;

}