/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class PropertiesDependenciesFileCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws Exception {

		if (fileName.endsWith("/dependencies.properties")) {
			return _formatDependenciesProperties(content);
		}

		return content;
	}

	private String _formatDependenciesProperties(String content) {
		List<String> lines = ListUtil.fromString(content);

		lines = ListUtil.sort(lines);

		StringBundler sb = new StringBundler(content.length() * 2);

		for (String line : lines) {
			line = StringUtil.removeChar(line, CharPool.SPACE);

			if (Validator.isNotNull(line) &&
				(line.charAt(0) != CharPool.POUND)) {

				sb.append(line);
				sb.append(CharPool.NEW_LINE);
			}
		}

		if (sb.index() > 0) {
			sb.setIndex(sb.index() - 1);
		}

		return sb.toString();
	}

}