/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaProcessCallableCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		Matcher matcher = _processCallablePattern.matcher(content);

		if (!matcher.find() ||
			content.contains("private static final long serialVersionUID")) {

			return content;
		}

		addMessage(
			fileName,
			"Assign ProcessCallable implementation a serialVersionUID",
			"process_callable.markdown");

		return content;
	}

	private final Pattern _processCallablePattern = Pattern.compile(
		"implements ProcessCallable\\b");

}