/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringUtil;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaFinderCacheCheck extends BaseFileCheck {

	@Override
	public boolean isPortalCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (fileName.endsWith("FinderImpl.java") &&
			content.contains("public static final FinderPath")) {

			_checkFinderCacheInterfaceMethod(fileName, content);

			content = _fixClearCache(fileName, content);
		}

		return content;
	}

	private void _checkFinderCacheInterfaceMethod(
		String fileName, String content) {

		Matcher matcher = _fetchByPrimaryKeysMethodPattern.matcher(content);

		if (!matcher.find()) {
			addMessage(
				fileName,
				"Missing override of BasePersistenceImpl." +
					"fetchByPrimaryKeys(Set<Serializable>)",
				"finderpath.markdown");
		}
	}

	private String _fixClearCache(String fileName, String content) {

		// LPS-47648

		if (fileName.contains("/test/integration/") ||
			fileName.contains("/testIntegration/java")) {

			content = StringUtil.replace(
				content, "FinderCacheUtil.clearCache();", StringPool.BLANK);
		}

		return content;
	}

	private final Pattern _fetchByPrimaryKeysMethodPattern = Pattern.compile(
		"@Override\n\tpublic Map<(.+)> fetchByPrimaryKeys\\(");

}