/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class JavaConfigurationAdminCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (fileName.contains("/test/") ||
			fileName.contains("/testIntegration/")) {

			return content;
		}

		Matcher matcher = _getConfigurationPattern.matcher(content);

		while (matcher.find()) {
			List<String> parametersList = JavaSourceUtil.getParameterList(
				content.substring(matcher.start()));

			if (parametersList.size() == 2) {
				String parameterName = parametersList.get(1);

				if (parameterName.equals("StringPool.QUESTION") ||
					parameterName.equals("\"?\"")) {

					continue;
				}
			}

			StringBundler sb = new StringBundler(5);

			sb.append("Incorrect call to '");
			sb.append(matcher.group(1));
			sb.append(StringPool.PERIOD);
			sb.append(matcher.group(2));
			sb.append(StringPool.APOSTROPHE);

			addMessage(
				fileName, sb.toString(), "configuration_admin.markdown",
				getLineCount(content, matcher.start()));
		}

		return content;
	}

	private final Pattern _getConfigurationPattern = Pattern.compile(
		"\\W_?([cC]onfigurationAdmin)\\.\\s*((get|createFactory)" +
			"Configuration)\\(");

}