/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Hugo Huijser
 */
public class CompatClassImportsCheck extends BaseFileCheck {

	@Override
	public void init() throws Exception {
		_compatClassNamesMap = getCompatClassNamesMap();
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		if (isPortalSource() || isSubrepository() ||
			absolutePath.contains("/ext-") ||
			absolutePath.contains("/portal-compat-shared/")) {

			return content;
		}

		return _fixCompatClassImports(content);
	}

	private String _fixCompatClassImports(String content) {
		for (Map.Entry<String, String> entry :
				_compatClassNamesMap.entrySet()) {

			String compatClassName = entry.getKey();
			String extendedClassName = entry.getValue();

			Pattern pattern = Pattern.compile(extendedClassName + "\\W");

			while (true) {
				Matcher matcher = pattern.matcher(content);

				if (!matcher.find()) {
					break;
				}

				content =
					content.substring(0, matcher.start()) + compatClassName +
						content.substring(matcher.end() - 1);
			}
		}

		return content;
	}

	private Map<String, String> _compatClassNamesMap;

}