/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

import com.liferay.source.formatter.checks.util.XMLSourceUtil;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class XMLSourceProcessor extends BaseSourceProcessor {

	@Override
	protected List<String> doGetFileNames() throws Exception {
		String[] excludes = {
			"**/.bnd/**", "**/.idea/**", "**/.ivy/**", "**/bin/**",
			"**/javadocs-*.xml", "**/logs/**", "**/portal-impl/**/*.action",
			"**/portal-impl/**/*.function", "**/portal-impl/**/*.macro",
			"**/portal-impl/**/*.testcase", "**/src/test/**",
			"**/test-classes/unit/**", "**/test-results/**", "**/test/unit/**",
			"**/tools/node**"
		};

		return getFileNames(excludes, getIncludes());
	}

	@Override
	protected String[] doGetIncludes() {
		return _INCLUDES;
	}

	@Override
	protected boolean hasGeneratedTag(String content) {
		if (!content.contains("@generated")) {
			return false;
		}

		int pos = -1;

		while (true) {
			pos = content.indexOf("@generated", pos + 1);

			if (pos == -1) {
				return false;
			}

			if (!XMLSourceUtil.isInsideCDATAMarkup(content, pos)) {
				return true;
			}
		}
	}

	private static final String[] _INCLUDES = {
		"**/*.action", "**/*.function", "**/*.jrxml", "**/*.macro", "**/*.pom",
		"**/*.testcase", "**/*.toggle", "**/*.xml",
		"**/definitions/liferay-*.xsd"
	};

}