/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.File;

import java.util.regex.Pattern;

/**
 * @author Peter Shin
 */
public class ExcludeSyntaxPattern {

	public ExcludeSyntaxPattern(
		ExcludeSyntax excludeSyntax, String excludePattern) {

		_excludeSyntax = excludeSyntax;

		if (_excludeSyntax == ExcludeSyntax.REGEX) {
			_excludePattern = StringUtil.replace(
				excludePattern, CharPool.SLASH, Pattern.quote(File.separator));
		}
		else {
			_excludePattern = excludePattern;
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof ExcludeSyntaxPattern)) {
			return false;
		}

		ExcludeSyntaxPattern excludeSyntaxPattern = (ExcludeSyntaxPattern)obj;

		ExcludeSyntax excludeSyntax = excludeSyntaxPattern.getExcludeSyntax();

		if (!excludeSyntax.equals(_excludeSyntax)) {
			return false;
		}

		String excludePattern = excludeSyntaxPattern.getExcludePattern();

		if (!excludePattern.equals(_excludePattern)) {
			return false;
		}

		return true;
	}

	public String getExcludePattern() {
		return _excludePattern;
	}

	public ExcludeSyntax getExcludeSyntax() {
		return _excludeSyntax;
	}

	@Override
	public int hashCode() {
		String s = _excludeSyntax.getValue();

		s = s.concat(_excludePattern);

		return s.hashCode();
	}

	private final String _excludePattern;
	private final ExcludeSyntax _excludeSyntax;

}