/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.permission.CommonPermissionUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.service.base.ContactServiceBaseImpl;
import java.util.List;

public class ContactServiceImpl
extends ContactServiceBaseImpl {
    public Contact getContact(long contactId) throws PortalException {
        Contact contact = this.contactPersistence.findByPrimaryKey(contactId);
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)contact.getClassNameId(), (long)contact.getClassPK(), (String)"VIEW");
        return contact;
    }

    public List<Contact> getContacts(long classNameId, long classPK, int start, int end, OrderByComparator<Contact> orderByComparator) throws PortalException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)classNameId, (long)classPK, (String)"VIEW");
        return this.contactPersistence.findByC_C(classNameId, classPK, start, end, orderByComparator);
    }

    public int getContactsCount(long classNameId, long classPK) throws PortalException {
        CommonPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)classNameId, (long)classPK, (String)"VIEW");
        return this.contactPersistence.countByC_C(classNameId, classPK);
    }
}

