/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.resiliency.spi.cache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerProvider;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.proxy.TargetLocator;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.resiliency.spi.cache.SPIPortalCacheManagerConfigurator;
import com.liferay.portal.nio.intraband.cache.BaseIntrabandPortalCacheManager;
import com.liferay.portal.nio.intraband.proxy.IntrabandProxyInstallationUtil;
import com.liferay.portal.nio.intraband.proxy.IntrabandProxyUtil;
import com.liferay.portal.nio.intraband.proxy.WarnLogExceptionHandler;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.concurrent.Future;

public class SPIPortalCacheManagerConfiguratorImpl
implements SPIPortalCacheManagerConfigurator {
    public PortalCacheManager<? extends Serializable, ? extends Serializable> createSPIPortalCacheManager(PortalCacheManager<? extends Serializable, ? extends Serializable> portalCacheManager) throws Exception {
        if (!SPIUtil.isSPI()) {
            return portalCacheManager;
        }
        SPI spi = SPIUtil.getSPI();
        RegistrationReference registrationReference = spi.getRegistrationReference();
        Future<String[]> future = IntrabandProxyInstallationUtil.installSkeleton(registrationReference, PortalCache.class, (TargetLocator)new IntrabandPortalCacheTargetLocator(portalCacheManager.getPortalCacheManagerName(), false));
        String[] skeletonProxyMethodSignatures = future.get();
        String[] stubProxyMethodSignatures = IntrabandProxyUtil.getProxyMethodSignatures(BaseIntrabandPortalCacheManager.getPortalCacheStubClass());
        IntrabandProxyInstallationUtil.checkProxyMethodSignatures(skeletonProxyMethodSignatures, stubProxyMethodSignatures);
        future = IntrabandProxyInstallationUtil.installSkeleton(registrationReference, PortalCacheManager.class, (TargetLocator)new IntrabandPortalCacheTargetLocator(portalCacheManager.getPortalCacheManagerName(), true));
        skeletonProxyMethodSignatures = future.get();
        Class<?> stubClass = IntrabandProxyUtil.getStubClass(BaseIntrabandPortalCacheManager.class, PortalCacheManager.class.getName());
        stubProxyMethodSignatures = IntrabandProxyUtil.getProxyMethodSignatures(stubClass);
        IntrabandProxyInstallationUtil.checkProxyMethodSignatures(skeletonProxyMethodSignatures, stubProxyMethodSignatures);
        return (PortalCacheManager)IntrabandProxyUtil.newStubInstance(stubClass, "", registrationReference, WarnLogExceptionHandler.INSTANCE);
    }

    private static class IntrabandPortalCacheTargetLocator
    implements TargetLocator {
        private final boolean _manager;
        private transient PortalCacheManager<?, ?> _portalCacheManager;
        private final String _portalCacheManagerName;

        public IntrabandPortalCacheTargetLocator(String portalCacheManagerName, boolean manager) {
            this._portalCacheManagerName = portalCacheManagerName;
            this._manager = manager;
        }

        public Object getTarget(String id) {
            if (this._manager) {
                return this._portalCacheManager;
            }
            return this._portalCacheManager.getPortalCache(id);
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            this._portalCacheManager = PortalCacheManagerProvider.getPortalCacheManager((String)this._portalCacheManagerName);
        }
    }
}

