/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.editor.configuration;

import com.liferay.portal.editor.configuration.EditorConfigProvider;
import com.liferay.portal.editor.configuration.EditorConfigurationImpl;
import com.liferay.portal.editor.configuration.EditorOptionsProvider;
import com.liferay.portal.kernel.editor.configuration.EditorConfigTransformer;
import com.liferay.portal.kernel.editor.configuration.EditorConfiguration;
import com.liferay.portal.kernel.editor.configuration.EditorConfigurationFactory;
import com.liferay.portal.kernel.editor.configuration.EditorOptions;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.Map;

public class EditorConfigurationFactoryImpl
implements EditorConfigurationFactory {
    private static EditorConfigProvider _editorConfigProvider;
    private static final ServiceTrackerMap<String, EditorConfigTransformer> _editorConfigTransformerServiceTrackerMap;
    private static EditorOptionsProvider _editorOptionsProvider;

    public EditorConfiguration getEditorConfiguration(String portletName, String editorConfigKey, String editorName, Map<String, Object> inputEditorTaglibAttributes, ThemeDisplay themeDisplay, RequestBackedPortletURLFactory requestBackedPortletURLFactory) {
        JSONObject configJSONObject = _editorConfigProvider.getConfigJSONObject(portletName, editorConfigKey, editorName, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        EditorOptions editorOptions = _editorOptionsProvider.getEditorOptions(portletName, editorConfigKey, editorName, inputEditorTaglibAttributes, themeDisplay, requestBackedPortletURLFactory);
        EditorConfigTransformer editorConfigTransformer = (EditorConfigTransformer)_editorConfigTransformerServiceTrackerMap.getService((Object)editorName);
        if (editorConfigTransformer != null) {
            editorConfigTransformer.transform(editorOptions, inputEditorTaglibAttributes, configJSONObject, themeDisplay, requestBackedPortletURLFactory);
        }
        return new EditorConfigurationImpl(configJSONObject, editorOptions);
    }

    public void setEditorConfigProvider(EditorConfigProvider editorConfigProvider) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _editorConfigProvider = editorConfigProvider;
    }

    public void setEditorOptionsProvider(EditorOptionsProvider editorOptionsProvider) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        _editorOptionsProvider = editorOptionsProvider;
    }

    static {
        _editorConfigTransformerServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(EditorConfigTransformer.class, (String)"editor.name");
    }
}

