/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetterUtilCheck
extends BaseFileCheck {
    private final Pattern _getterUtilGetPattern = Pattern.compile("GetterUtil\\.get(Boolean|Double|Float|Integer|Long|Number|Object|Short|String)\\((.*?)\\);\n", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!fileName.endsWith("GetterUtilTest.java")) {
            this._checkGetterUtilGet(fileName, content);
        }
        return content;
    }

    private void _checkGetterUtilGet(String fileName, String content) throws Exception {
        Matcher matcher = this._getterUtilGetPattern.matcher(content);
        while (matcher.find()) {
            List<String> parametersList;
            if (ToolsUtil.isInsideQuotes(content, matcher.start()) || (parametersList = JavaSourceUtil.getParameterList(matcher.group())).size() != 2) continue;
            String defaultVariableName = "DEFAULT_" + StringUtil.toUpperCase(matcher.group(1));
            Field defaultValuefield = GetterUtil.class.getDeclaredField(defaultVariableName);
            String defaultValue = String.valueOf(defaultValuefield.get(null));
            defaultValue = defaultValue.replaceFirst("\\.0", "");
            String value = parametersList.get(1);
            if ((value = value.replaceFirst("0(\\.0)?[dDfFlL]?", "0")).equals("StringPool.BLANK")) {
                value = "";
            }
            if (!Objects.equals(value, defaultValue)) continue;
            this.addMessage(fileName, "No need to pass default value '" + parametersList.get(1) + "'", this.getLineCount(content, matcher.start()));
        }
    }
}

