/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.util.CheckType;
import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import java.util.TreeSet;

public class CheckstyleLogger
extends DefaultLogger {
    private static final Set<SourceFormatterMessage> _sourceFormatterMessages = new TreeSet<SourceFormatterMessage>();
    private final String _baseDirName;

    public CheckstyleLogger(OutputStream outputStream, boolean closeStreamsAfterUse, String baseDirName) {
        super(outputStream, closeStreamsAfterUse);
        this._baseDirName = baseDirName;
        _sourceFormatterMessages.clear();
    }

    public void addError(AuditEvent auditEvent) {
        String sourceName = StringUtil.extractLast(auditEvent.getSourceName(), '.');
        _sourceFormatterMessages.add(new SourceFormatterMessage(this._getRelativizedFileName(auditEvent), auditEvent.getMessage(), CheckType.CHECKSTYLE, sourceName, null, auditEvent.getLine()));
        super.addError(auditEvent);
    }

    public Set<SourceFormatterMessage> getSourceFormatterMessages() {
        return _sourceFormatterMessages;
    }

    private Path _getAbsoluteNormalizedPath(String pathName) {
        Path path = Paths.get(pathName, new String[0]);
        path = path.toAbsolutePath();
        return path.normalize();
    }

    private String _getRelativizedFileName(AuditEvent auditEvent) {
        if (Validator.isNull(this._baseDirName)) {
            return auditEvent.getFileName();
        }
        Path baseDirPath = this._getAbsoluteNormalizedPath(this._baseDirName);
        Path relativizedPath = baseDirPath.relativize(this._getAbsoluteNormalizedPath(auditEvent.getFileName()));
        return this._baseDirName + StringUtil.replace(relativizedPath.toString(), '\\', '/');
    }
}

