/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.checks.StringConcatenationCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import java.util.List;

public class PlusStatementCheck
extends StringConcatenationCheck {
    private static final String _MSG_INCORRECT_TABBING = "tabbing.incorrect";

    public int[] getDefaultTokens() {
        return new int[]{125};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        this._checkPlusOperator(detailAST);
    }

    private void _checkPlusOperator(DetailAST detailAST) {
        String trimmedLine2;
        this._checkTabbing(detailAST);
        if (detailAST.getChildCount() != 2) {
            return;
        }
        DetailAST firstChild = detailAST.getFirstChild();
        String literalString1 = this._getLiteralString(firstChild);
        if (literalString1 == null) {
            return;
        }
        DetailAST lastChild = detailAST.getLastChild();
        String literalString2 = this._getLiteralString(lastChild);
        if (literalString2 == null) {
            return;
        }
        if (firstChild.getLineNo() == lastChild.getLineNo()) {
            this.log(firstChild.getLineNo(), "literal.string.combine", new Object[]{literalString1, literalString2});
            return;
        }
        if (this._isRegexPattern(detailAST)) {
            return;
        }
        this.checkLiteralStringStartAndEndCharacter(literalString1, literalString2, detailAST.getLineNo());
        String line1 = this.getLine(lastChild.getLineNo() - 2);
        String line2 = this.getLine(lastChild.getLineNo() - 1);
        if (this._getLeadingTabCount(line1) == this._getLeadingTabCount(line2)) {
            return;
        }
        int lineLength1 = CommonUtils.lengthExpandedTabs((String)line1, (int)line1.length(), (int)this.getTabWidth());
        if (lineLength1 + (trimmedLine2 = StringUtil.trim(line2)).length() - 4 <= this.maxLineLength) {
            this.log(lastChild.getLineNo(), "literal.string.combine", new Object[]{literalString1, literalString2});
            return;
        }
        DetailAST parentAST = detailAST.getParent();
        if (parentAST.getType() == 125 && lineLength1 + literalString2.length() <= this.maxLineLength) {
            this.log(detailAST.getLineNo(), "literal.string.combine", new Object[]{literalString1, literalString2});
            return;
        }
        int pos = this.getStringBreakPos(literalString1, literalString2, this.maxLineLength - lineLength1);
        if (pos != -1) {
            this.log(lastChild.getLineNo(), "literal.string.move", new Object[]{literalString2.substring(0, pos + 1)});
        }
    }

    private void _checkTabbing(DetailAST detailAST) {
        int afterPlusLineNo;
        DetailAST afterPlusAST = detailAST.getLastChild();
        if (afterPlusAST.getType() == 77) {
            while (afterPlusAST.getType() != 76) {
                afterPlusAST = afterPlusAST.getPreviousSibling();
            }
        }
        if ((afterPlusLineNo = DetailASTUtil.getStartLine(afterPlusAST)) == detailAST.getLineNo()) {
            return;
        }
        String line1 = this.getLine(detailAST.getLineNo() - 1);
        String line2 = this.getLine(afterPlusLineNo - 1);
        int tabCount = this._getLeadingTabCount(line1);
        if (tabCount + 1 != this._getLeadingTabCount(line2)) {
            this.log(afterPlusLineNo, _MSG_INCORRECT_TABBING, new Object[]{tabCount + 1});
        }
    }

    private int _getLeadingTabCount(String line) {
        int leadingTabCount = 0;
        while (line.startsWith("\t")) {
            line = line.substring(1);
            ++leadingTabCount;
        }
        return leadingTabCount;
    }

    private String _getLiteralString(DetailAST detailAST) {
        DetailAST lastChild;
        String literalString = null;
        if (detailAST.getType() == 139) {
            literalString = detailAST.getText();
        } else if (detailAST.getType() == 125 && detailAST.getChildCount() == 2 && (lastChild = detailAST.getLastChild()).getType() == 139) {
            literalString = lastChild.getText();
        }
        if (literalString != null) {
            return literalString.substring(1, literalString.length() - 1);
        }
        return null;
    }

    private boolean _isRegexPattern(DetailAST detailAST) {
        for (DetailAST parentAST = detailAST.getParent(); parentAST != null; parentAST = parentAST.getParent()) {
            if (parentAST.getType() != 27) {
                continue;
            }
            DetailAST firstChild = parentAST.getFirstChild();
            if (firstChild.getType() != 59) {
                return false;
            }
            List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(firstChild, false, 58);
            if (nameASTList.size() != 2) {
                return false;
            }
            DetailAST classNameAST = nameASTList.get(0);
            DetailAST methodNameAST = nameASTList.get(1);
            String methodCallClassName = classNameAST.getText();
            String methodCallMethodName = methodNameAST.getText();
            return methodCallMethodName.equals("matches") || methodCallClassName.equals("Pattern") && methodCallMethodName.equals("compile");
        }
        return false;
    }
}

