/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidatorEqualsCheck
extends BaseFileCheck {
    private final Pattern _validatorEqualsPattern = Pattern.compile("\\WValidator\\.equals\\(");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        this._checkValidatorEquals(fileName, content);
        return content;
    }

    private void _checkValidatorEquals(String fileName, String content) {
        Matcher matcher = this._validatorEqualsPattern.matcher(content);
        while (matcher.find()) {
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            this.addMessage(fileName, "Use Objects.equals(Object, Object) instead of Validator.equals(Object, Object)", "equals.markdown", this.getLineCount(content, matcher.start()));
        }
    }
}

