/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portlet.documentlibrary.util.Atom;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class JQTFastStart {
    private static final Log _log = LogFactoryUtil.getLog(JQTFastStart.class);
    private static final JQTFastStart _instance = new JQTFastStart();

    public static void convert(File inputFile, File outputFile) throws IOException {
        _instance.doConvert(inputFile, outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doConvert(File inputFile, File outputFile) throws IOException {
        this.validate(inputFile, outputFile);
        RandomAccessFile randomAccessInputFile = null;
        RandomAccessFile randomAccessOutputFile = null;
        try {
            randomAccessInputFile = new RandomAccessFile(inputFile, "r");
            Atom atom = null;
            Atom ftypAtom = null;
            boolean fastStart = false;
            boolean ftypFound = false;
            boolean mdatFound = false;
            while (randomAccessInputFile.getFilePointer() < randomAccessInputFile.length()) {
                atom = new Atom(randomAccessInputFile);
                if (!atom.isTopLevelAtom()) {
                    throw new IOException("Non top level atom was found " + atom.getType());
                }
                if (ftypFound && !mdatFound && atom.isMOOV()) {
                    fastStart = true;
                    break;
                }
                if (atom.isFTYP()) {
                    ftypAtom = atom;
                    ftypAtom.fillBuffer(randomAccessInputFile);
                    ftypFound = true;
                    continue;
                }
                if (atom.isMDAT()) {
                    mdatFound = true;
                    randomAccessInputFile.skipBytes((int)atom.getSize());
                    continue;
                }
                randomAccessInputFile.skipBytes((int)atom.getSize());
            }
            if (fastStart) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"The movie is already a fast start MP4");
                }
                FileUtil.move((File)inputFile, (File)outputFile);
                return;
            }
            if (!atom.isMOOV()) {
                throw new IOException("Last atom was not of type MOOV");
            }
            randomAccessInputFile.seek(atom.getOffset());
            Atom moovAtom = atom;
            moovAtom.fillBuffer(randomAccessInputFile);
            if (moovAtom.hasCompressedMoovAtom()) {
                throw new IOException("Compressed MOOV atoms are unsupported");
            }
            moovAtom.patchAtom();
            randomAccessInputFile.seek(ftypAtom.getOffset() + ftypAtom.getSize());
            randomAccessOutputFile = new RandomAccessFile(outputFile, "rw");
            randomAccessOutputFile.setLength(0L);
            randomAccessOutputFile.write(ftypAtom.getBuffer());
            randomAccessOutputFile.write(moovAtom.getBuffer());
            byte[] buffer = new byte[0x100000];
            while (randomAccessInputFile.getFilePointer() + (long)buffer.length < moovAtom.getOffset()) {
                int read = randomAccessInputFile.read(buffer);
                randomAccessOutputFile.write(buffer, 0, read);
            }
            int bufferSize = (int)(moovAtom.getOffset() - randomAccessInputFile.getFilePointer());
            buffer = new byte[bufferSize];
            randomAccessInputFile.readFully(buffer);
            randomAccessOutputFile.write(buffer);
        }
        finally {
            if (randomAccessInputFile != null) {
                randomAccessInputFile.close();
            }
            if (randomAccessOutputFile != null) {
                randomAccessOutputFile.close();
            }
        }
    }

    protected void validate(File inputFile, File outputFile) throws IOException {
        if (!inputFile.exists() || !inputFile.canRead()) {
            throw new IOException("Input file cannot be read " + inputFile);
        }
        if (outputFile.exists()) {
            throw new IOException("Output file alread exists " + outputFile);
        }
        String inputFileAbsolutePath = inputFile.getAbsolutePath();
        if (inputFileAbsolutePath.equals(outputFile.getAbsolutePath())) {
            throw new IOException("Input file and output file cannot be the same " + inputFile);
        }
    }
}

