/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class PortletCategoryUtil {
    public static Set<String> getFirstChildPortletIds(PortletCategory portletCategory) {
        Set portletIds = portletCategory.getPortletIds();
        if (!portletIds.isEmpty()) {
            return portletIds;
        }
        for (PortletCategory curPortletCategory : portletCategory.getCategories()) {
            portletIds = curPortletCategory.getPortletIds();
            if (!portletIds.isEmpty()) {
                return portletIds;
            }
            PortletCategoryUtil.getFirstChildPortletIds(curPortletCategory);
        }
        return Collections.emptySet();
    }

    public static String getPortletCategoryKey(String legacyPortletCategoryKey) {
        if (Objects.equals(legacyPortletCategoryKey, "apps") || Objects.equals(legacyPortletCategoryKey, "marketplace")) {
            return "control_panel.apps";
        }
        if (Objects.equals(legacyPortletCategoryKey, "configuration") || Objects.equals(legacyPortletCategoryKey, "portal") || Objects.equals(legacyPortletCategoryKey, "server")) {
            return "control_panel.configuration";
        }
        if (Objects.equals(legacyPortletCategoryKey, "content")) {
            return "site_administration.content";
        }
        if (Objects.equals(legacyPortletCategoryKey, "my")) {
            return "user.my_account";
        }
        if (Objects.equals(legacyPortletCategoryKey, "sites")) {
            return "control_panel.sites";
        }
        if (Objects.equals(legacyPortletCategoryKey, "users")) {
            return "control_panel.users";
        }
        return legacyPortletCategoryKey;
    }

    public static PortletCategory getRelevantPortletCategory(PermissionChecker permissionChecker, long companyId, Layout layout, PortletCategory portletCategory, LayoutTypePortlet layoutTypePortlet) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        Set panelSelectedPortletIds = SetUtil.fromArray((Object[])StringUtil.split((String)typeSettingsProperties.getProperty("panelSelectedPortlets")));
        return PortletCategoryUtil.getRelevantPortletCategory(permissionChecker, companyId, layout, portletCategory, panelSelectedPortletIds, layoutTypePortlet);
    }

    protected static PortletCategory getRelevantPortletCategory(PermissionChecker permissionChecker, long companyId, Layout layout, PortletCategory portletCategory, Set<String> panelSelectedPortletIds, LayoutTypePortlet layoutTypePortlet) throws Exception {
        PortletCategory relevantPortletCategory = new PortletCategory(portletCategory.getName(), portletCategory.getPortletIds());
        for (PortletCategory curPortletCategory : portletCategory.getCategories()) {
            HashSet<String> portletIds = new HashSet<String>();
            if (curPortletCategory.isHidden()) continue;
            for (String portletId : curPortletCategory.getPortletIds()) {
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
                if (portlet == null || portlet.isSystem() || !portlet.isActive() || portlet.isUndeployedPortlet()) continue;
                if (layout.isTypePanel() && panelSelectedPortletIds.contains(portlet.getRootPortletId())) {
                    portletIds.add(portlet.getPortletId());
                    continue;
                }
                if (layout.isTypePanel() && !panelSelectedPortletIds.contains(portlet.getRootPortletId()) || !PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (Portlet)portlet, (String)"ADD_TO_PAGE")) continue;
                if (!portlet.isInstanceable() && layoutTypePortlet.hasPortletId(portlet.getPortletId())) {
                    portletIds.add(portlet.getPortletId());
                    continue;
                }
                portletIds.add(portlet.getPortletId());
            }
            PortletCategory curRelevantPortletCategory = PortletCategoryUtil.getRelevantPortletCategory(permissionChecker, companyId, layout, curPortletCategory, panelSelectedPortletIds, layoutTypePortlet);
            curRelevantPortletCategory.setPortletIds(portletIds);
            Collection categories = curRelevantPortletCategory.getCategories();
            if (categories.isEmpty() && portletIds.isEmpty()) continue;
            relevantPortletCategory.addCategory(curRelevantPortletCategory);
        }
        return relevantPortletCategory;
    }
}

