/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class UpgradeResourcePermission
extends UpgradeProcess {
    protected void createIndex() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQLTemplateString("create index IX_D5F1E2A2 on ResourcePermission (name[$COLUMN_LENGTH:255$])", false, false);
        }
    }

    protected void doUpgrade() throws Exception {
        this.createIndex();
        this.upgradeResourcePermissions();
    }

    protected void upgradeResourcePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("update ResourcePermission set viewActionId = [$FALSE$] where MOD(actionIds, 2) = 0");
            this.runSQL("update ResourcePermission set viewActionId = [$TRUE$] where MOD(actionIds, 2) = 1");
            try (PreparedStatement ps1 = this.connection.prepareStatement("select distinct name from ResourcePermission");
                 ResultSet rs1 = ps1.executeQuery();
                 PreparedStatement ps2 = this.connection.prepareStatement("select distinct primKey from ResourcePermission where name = ?");){
                while (rs1.next()) {
                    ArrayList<String> stringPrimKeys = new ArrayList<String>();
                    String name = rs1.getString("name");
                    ps2.setString(1, name);
                    try (ResultSet rs2 = ps2.executeQuery();){
                        while (rs2.next()) {
                            String primKey = rs2.getString("primKey");
                            if (GetterUtil.getLong((String)primKey) > 0L || primKey.contains("_LAYOUT_")) continue;
                            stringPrimKeys.add(primKey);
                        }
                    }
                    this._updatePrimKeyIdsByName(name, stringPrimKeys);
                }
            }
        }
    }

    private void _updatePrimKeyIds(String sql, String name, List<String> primKeys) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement(SQLTransformer.transform(sql));){
            ps.setString(1, name);
            for (int i = 0; i < primKeys.size(); ++i) {
                String primKey = primKeys.get(i);
                ps.setString(i + 2, primKey);
            }
            ps.executeUpdate();
        }
    }

    private void _updatePrimKeyIdsByName(String name, List<String> primKeys) throws Exception {
        if (primKeys.isEmpty()) {
            this._updatePrimKeyIds("update ResourcePermission set primKeyId = CAST_LONG(primKey) where name = ? and primKey not like '%_LAYOUT_%'", name, primKeys);
            this._updatePrimKeyIds("update ResourcePermission set primKeyId = 0 where name = ? and primKey like '%_LAYOUT_%'", name, primKeys);
            return;
        }
        StringBundler sb = new StringBundler(primKeys.size() + 1);
        sb.append("in (?");
        for (int i = 1; i < primKeys.size(); ++i) {
            sb.append(", ?");
        }
        sb.append(")");
        String inClause = sb.toString();
        this._updatePrimKeyIds(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKeyId = 0 where name = ? ", "and (primKey like '%_LAYOUT_%' or primKey ", inClause, ")"}), name, primKeys);
        this._updatePrimKeyIds(StringBundler.concat((String[])new String[]{"update ResourcePermission set primKeyId = CAST_LONG(primKey", ") where name = ? and (primKey not like '%_LAYOUT_%' and ", "primKey not ", inClause, ")"}), name, primKeys);
    }
}

