/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.dynamic.data.mapping.kernel.DDMStructureManagerUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMTemplate;
import com.liferay.dynamic.data.mapping.kernel.DDMTemplateManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.template.DDMTemplateResource;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.template.TemplateResourceParser;

@OSGiBeanProperties(property={"lang.type=ftl", "lang.type=vm"}, service={TemplateResourceParser.class})
public class DDMTemplateResourceParser
implements TemplateResourceParser {
    private static final Log _log = LogFactoryUtil.getLog(DDMTemplateResourceParser.class);

    @Override
    public TemplateResource getTemplateResource(String templateId) throws TemplateException {
        int pos = templateId.indexOf("_TEMPLATE_CONTEXT_/");
        if (pos == -1 && (pos = templateId.indexOf("_JOURNAL_CONTEXT_/")) == -1) {
            return null;
        }
        try {
            DDMTemplate ddmTemplate;
            int w = templateId.indexOf(47, pos);
            int x = templateId.indexOf(47, w + 1);
            int y = templateId.indexOf(47, x + 1);
            int z = templateId.indexOf(47, y + 1);
            long companyId = GetterUtil.getLong((String)templateId.substring(w + 1, x));
            long groupId = GetterUtil.getLong((String)templateId.substring(x + 1, y));
            long classNameId = GetterUtil.getLong((String)templateId.substring(y + 1, z));
            String ddmTemplateKey = templateId.substring(z + 1);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Loading {companyId=", String.valueOf(companyId), ", groupId=", String.valueOf(groupId), ", classNameId=", String.valueOf(classNameId), ", ddmTemplateKey=", ddmTemplateKey, "}"}));
            }
            if ((ddmTemplate = DDMTemplateManagerUtil.fetchTemplate((long)groupId, (long)classNameId, (String)ddmTemplateKey)) == null) {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup((long)companyId);
                ddmTemplate = DDMTemplateManagerUtil.fetchTemplate((long)companyGroup.getGroupId(), (long)classNameId, (String)ddmTemplateKey);
                if (ddmTemplate == null) {
                    classNameId = PortalUtil.getClassNameId((Class)DDMStructureManagerUtil.getDDMStructureModelClass());
                    ddmTemplate = DDMTemplateManagerUtil.fetchTemplate((long)groupId, (long)classNameId, (String)ddmTemplateKey);
                }
                if (ddmTemplate == null) {
                    ddmTemplate = DDMTemplateManagerUtil.fetchTemplate((long)companyGroup.getGroupId(), (long)classNameId, (String)ddmTemplateKey);
                }
            }
            if (ddmTemplate == null) {
                return null;
            }
            return new DDMTemplateResource(ddmTemplate.getTemplateKey(), ddmTemplate);
        }
        catch (Exception e) {
            throw new TemplateException("Unable to find template " + templateId, (Throwable)e);
        }
    }

    @Override
    public boolean isTemplateResourceValid(String templateId, String langType) {
        return templateId.contains("_JOURNAL_CONTEXT_") || templateId.contains("_TEMPLATE_CONTEXT_");
    }
}

