/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.spring.bean;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class BeanReferenceRefreshUtil {
    private static final Log _log = LogFactoryUtil.getLog(BeanReferenceRefreshUtil.class);
    private static final PACL _pacl = new NoPACL();
    private static final Map<BeanFactory, BeanRegistrations> _registeredRefreshPoints = new IdentityHashMap<BeanFactory, BeanRegistrations>();

    public static void refresh(BeanFactory beanFactory) throws Exception {
        BeanRegistrations beanRegistrations = _registeredRefreshPoints.remove(beanFactory);
        if (beanRegistrations == null) {
            return;
        }
        beanRegistrations.refresh();
    }

    public static void registerRefreshPoint(BeanFactory beanFactory, Object targetBean, Field field, String referencedBeanName) {
        BeanRegistrations beanRegistrations = _registeredRefreshPoints.get(beanFactory);
        if (beanRegistrations == null) {
            beanRegistrations = new BeanRegistrations(beanFactory);
            _registeredRefreshPoints.put(beanFactory, beanRegistrations);
        }
        beanRegistrations.addRefreshPoint(targetBean, field, referencedBeanName);
    }

    private static class RefreshPoint {
        private final Field _field;
        private final String _referencedBeanName;

        public RefreshPoint(Field field, String referencedBeanName) {
            this._field = field;
            this._referencedBeanName = referencedBeanName;
        }
    }

    private static class NoPACL
    implements PACL {
        private NoPACL() {
        }

        @Override
        public Object getNewReferencedBean(String referencedBeanName, BeanFactory beanFactory) {
            try {
                return beanFactory.getBean(referencedBeanName);
            }
            catch (NoSuchBeanDefinitionException nsbde) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)StringBundler.concat((String[])new String[]{"Bean ", referencedBeanName, " may be defined in ", "the portal"}));
                }
                return PortalBeanLocatorUtil.locate((String)referencedBeanName);
            }
        }
    }

    private static class BeanRegistrations {
        private final BeanFactory _beanFactory;
        private final Map<Object, List<RefreshPoint>> _beansToRefresh = new IdentityHashMap<Object, List<RefreshPoint>>();

        public BeanRegistrations(BeanFactory beanFactory) {
            this._beanFactory = beanFactory;
        }

        public void addRefreshPoint(Object bean, Field field, String referencedBeanName) {
            List<RefreshPoint> refreshPoints = this._beansToRefresh.get(bean);
            if (refreshPoints == null) {
                refreshPoints = new ArrayList<RefreshPoint>();
                this._beansToRefresh.put(bean, refreshPoints);
            }
            refreshPoints.add(new RefreshPoint(field, referencedBeanName));
        }

        public void refresh() throws Exception {
            for (Map.Entry<Object, List<RefreshPoint>> entry : this._beansToRefresh.entrySet()) {
                this._refresh(entry.getKey(), entry.getValue());
            }
        }

        private void _refresh(Object targetBean, List<RefreshPoint> refreshPoints) throws Exception {
            for (RefreshPoint refreshPoint : refreshPoints) {
                this._refresh(targetBean, refreshPoint);
            }
        }

        private void _refresh(Object targetBean, RefreshPoint refreshPoint) throws Exception {
            Field field = refreshPoint._field;
            Object oldReferenceBean = field.get(targetBean);
            String referencedBeanName = refreshPoint._referencedBeanName;
            Object newReferencedBean = _pacl.getNewReferencedBean(referencedBeanName, this._beanFactory);
            if (oldReferenceBean == newReferencedBean) {
                return;
            }
            field.set(targetBean, newReferencedBean);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Refreshed field ", String.valueOf(field), " with old value ", String.valueOf(oldReferenceBean), " with new value ", String.valueOf(newReferencedBean), " on bean ", String.valueOf(targetBean)}));
            }
        }
    }

    public static interface PACL {
        public Object getNewReferencedBean(String var1, BeanFactory var2);
    }
}

