/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PasswordPolicy;
import com.liferay.portal.kernel.model.PasswordTracker;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.service.base.PasswordTrackerLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class PasswordTrackerLocalServiceImpl
extends PasswordTrackerLocalServiceBaseImpl {
    public void deletePasswordTrackers(long userId) {
        this.passwordTrackerPersistence.removeByUserId(userId);
    }

    public boolean isSameAsCurrentPassword(long userId, String newClearTextPwd) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        String currentPwd = user.getPassword();
        if (user.isPasswordEncrypted()) {
            String newEncPwd = PasswordEncryptorUtil.encrypt((String)newClearTextPwd, (String)user.getPassword());
            return currentPwd.equals(newEncPwd);
        }
        return currentPwd.equals(newClearTextPwd);
    }

    public boolean isValidPassword(long userId, String newClearTextPwd) throws PortalException {
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        if (passwordPolicy == null || !passwordPolicy.getHistory()) {
            return true;
        }
        int historyCount = 1;
        List passwordTrackers = this.passwordTrackerPersistence.findByUserId(userId);
        for (PasswordTracker passwordTracker : passwordTrackers) {
            String newEncPwd;
            if (historyCount >= passwordPolicy.getHistoryCount()) break;
            String oldEncPwd = passwordTracker.getPassword();
            if (oldEncPwd.equals(newEncPwd = PasswordEncryptorUtil.encrypt((String)newClearTextPwd, (String)oldEncPwd))) {
                return false;
            }
            ++historyCount;
        }
        return true;
    }

    public void trackPassword(long userId, String encPassword) throws PortalException {
        PasswordPolicy passwordPolicy = this.passwordPolicyLocalService.getPasswordPolicyByUserId(userId);
        if (passwordPolicy != null && passwordPolicy.isHistory()) {
            long passwordTrackerId = this.counterLocalService.increment();
            PasswordTracker passwordTracker = this.passwordTrackerPersistence.create(passwordTrackerId);
            passwordTracker.setUserId(userId);
            passwordTracker.setCreateDate(new Date());
            passwordTracker.setPassword(encPassword);
            this.passwordTrackerPersistence.update((BaseModel)passwordTracker);
        }
    }
}

