/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.orm.hibernate.event;

import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.engine.PersistenceContext;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.event.FlushEvent;
import org.hibernate.event.def.DefaultFlushEventListener;
import org.hibernate.stat.Statistics;
import org.hibernate.stat.StatisticsImplementor;

public class NestableFlushEventListener
extends DefaultFlushEventListener {
    public static final NestableFlushEventListener INSTANCE = new NestableFlushEventListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFlush(FlushEvent event) throws HibernateException {
        Map collectionEntries;
        EventSource eventSource = event.getSession();
        PersistenceContext persistenceContext = eventSource.getPersistenceContext();
        Map entityEntries = persistenceContext.getEntityEntries();
        if (entityEntries.isEmpty() && (collectionEntries = persistenceContext.getCollectionEntries()).isEmpty()) {
            return;
        }
        boolean flushing = persistenceContext.isFlushing();
        try {
            this.flushEverythingToExecutions(event);
            persistenceContext.setFlushing(true);
            this.performExecutions(eventSource);
            this.postFlush((SessionImplementor)eventSource);
        }
        finally {
            persistenceContext.setFlushing(flushing);
        }
        SessionFactoryImplementor sessionFactoryImplementor = eventSource.getFactory();
        Statistics statistics = sessionFactoryImplementor.getStatistics();
        if (statistics.isStatisticsEnabled()) {
            StatisticsImplementor statisticsImplementor = sessionFactoryImplementor.getStatisticsImplementor();
            statisticsImplementor.flush();
        }
    }
}

