/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.dao.jdbc.pool.metrics;

import com.liferay.portal.dao.jdbc.pool.metrics.BaseConnectionPoolMetrics;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class HikariConnectionPoolMetrics
extends BaseConnectionPoolMetrics {
    private static final Log _log = LogFactoryUtil.getLog(HikariConnectionPoolMetrics.class);
    private HikariPoolMXBean _connectionPool;
    private final Object _dataSource;
    private boolean _initializationFailed;

    public HikariConnectionPoolMetrics(Object dataSource) {
        this._dataSource = dataSource;
    }

    public int getNumActive() {
        if (!this._initializationFailed && this._connectionPool == null) {
            this.initializeConnectionPool();
        }
        if (this._initializationFailed) {
            return -1;
        }
        return this._connectionPool.getActiveConnections();
    }

    public int getNumIdle() {
        if (!this._initializationFailed && this._connectionPool == null) {
            this.initializeConnectionPool();
        }
        if (this._initializationFailed) {
            return -1;
        }
        return this._connectionPool.getIdleConnections();
    }

    @Override
    protected Object getDataSource() {
        if (this._initializationFailed) {
            return null;
        }
        return this._dataSource;
    }

    @Override
    protected String getPoolName() {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        try {
            Class<?> clazz = contextClassLoader.loadClass("com.zaxxer.hikari.HikariDataSource");
            Method method = clazz.getMethod("getPoolName", new Class[0]);
            return (String)method.invoke(this._dataSource, new Object[0]);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)e.getMessage(), (Throwable)e);
            }
            return null;
        }
    }

    @Override
    protected void initializeConnectionPool() {
        block3: {
            if (this.getPoolName() == null) {
                this._initializationFailed = true;
                return;
            }
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            try {
                ObjectName objectName = new ObjectName("com.zaxxer.hikari:type=Pool (" + this.getPoolName() + ")");
                this._connectionPool = JMX.newMXBeanProxy(mBeanServer, objectName, HikariPoolMXBean.class);
            }
            catch (Exception e) {
                this._initializationFailed = true;
                if (!_log.isDebugEnabled()) break block3;
                _log.debug((Object)e.getMessage());
            }
        }
        super.initializeConnectionPool();
    }
}

