/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.increment;

import com.liferay.portal.kernel.increment.Increment;

public abstract class OverrideIncrement<T extends Comparable<T>>
implements Increment<T> {
    protected T value;

    public OverrideIncrement(T value) {
        this.value = value;
    }

    @Override
    public void decrease(T delta) {
        if (this.value.compareTo(delta) > 0) {
            this.value = delta;
        }
    }

    @Override
    public OverrideIncrement<T> decreaseForNew(T delta) {
        if (this.value.compareTo(delta) < 0) {
            delta = this.value;
        }
        return this.createOverrideIncrement(delta);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void increase(T delta) {
        if (this.value.compareTo(delta) < 0) {
            this.value = delta;
        }
    }

    @Override
    public OverrideIncrement<T> increaseForNew(T delta) {
        if (this.value.compareTo(delta) > 0) {
            delta = this.value;
        }
        return this.createOverrideIncrement(delta);
    }

    @Override
    public void setValue(T value) {
        this.value = value;
    }

    protected abstract OverrideIncrement<T> createOverrideIncrement(T var1);
}

