/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.util;

import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.source.formatter.SourceFormatterArgs;
import com.liferay.source.formatter.checks.configuration.SourceFormatterSuppressions;
import com.liferay.source.formatter.checkstyle.Checker;
import com.liferay.source.formatter.checkstyle.util.CheckstyleLogger;
import com.puppycrawl.tools.checkstyle.ConfigurationLoader;
import com.puppycrawl.tools.checkstyle.DefaultConfiguration;
import com.puppycrawl.tools.checkstyle.PropertiesExpander;
import com.puppycrawl.tools.checkstyle.PropertyResolver;
import com.puppycrawl.tools.checkstyle.api.AuditListener;
import com.puppycrawl.tools.checkstyle.api.Configuration;
import com.puppycrawl.tools.checkstyle.api.Filter;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.InputSource;

public class CheckstyleUtil {
    public static Configuration addAttribute(Configuration configuration, String key, String value, String ... regexChecks) {
        String name;
        if (!(configuration instanceof DefaultConfiguration)) {
            return configuration;
        }
        DefaultConfiguration defaultConfiguration = (DefaultConfiguration)configuration;
        DefaultConfiguration treeWalkerModule = null;
        for (Configuration childConfiguration : defaultConfiguration.getChildren()) {
            name = childConfiguration.getName();
            if (!name.equals("TreeWalker") || !(childConfiguration instanceof DefaultConfiguration)) continue;
            treeWalkerModule = (DefaultConfiguration)childConfiguration;
            break;
        }
        if (treeWalkerModule == null) {
            return configuration;
        }
        for (Configuration childConfiguration : treeWalkerModule.getChildren()) {
            if (!(childConfiguration instanceof DefaultConfiguration)) continue;
            name = childConfiguration.getName();
            for (String regexCheck : regexChecks) {
                if (!name.matches(regexCheck)) continue;
                DefaultConfiguration defaultChildConfiguration = (DefaultConfiguration)childConfiguration;
                defaultChildConfiguration.addAttribute(key, value);
            }
        }
        return defaultConfiguration;
    }

    public static Checker getChecker(Configuration configuration, SourceFormatterSuppressions sourceFormatterSuppressions, SourceFormatterArgs sourceFormatterArgs) throws Exception {
        Checker checker = new Checker();
        ClassLoader classLoader = CheckstyleUtil.class.getClassLoader();
        checker.setModuleClassLoader(classLoader);
        checker.addFilter((Filter)sourceFormatterSuppressions.getCheckstyleFilterSet());
        checker.configure(configuration);
        CheckstyleLogger checkstyleLogger = new CheckstyleLogger(new UnsyncByteArrayOutputStream(), true, sourceFormatterArgs.getBaseDirName());
        checker.addListener((AuditListener)checkstyleLogger);
        checker.setCheckstyleLogger(checkstyleLogger);
        return checker;
    }

    public static List<String> getCheckNames(Configuration configuration) {
        ArrayList<String> checkNames = new ArrayList<String>();
        String name = configuration.getName();
        if (name.startsWith("com.liferay.")) {
            int pos = name.lastIndexOf(46);
            checkNames.add(name.substring(pos + 1));
        }
        for (Configuration childConfiguration : configuration.getChildren()) {
            checkNames.addAll(CheckstyleUtil.getCheckNames(childConfiguration));
        }
        return checkNames;
    }

    public static Configuration getConfiguration(String configurationFileName) throws Exception {
        ClassLoader classLoader = CheckstyleUtil.class.getClassLoader();
        return ConfigurationLoader.loadConfiguration((InputSource)new InputSource(classLoader.getResourceAsStream(configurationFileName)), (PropertyResolver)new PropertiesExpander(System.getProperties()), (boolean)false);
    }
}

