/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.checks.BaseCheck;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import java.util.List;

public class FullyQualifiedNameCheck
extends BaseCheck {
    private static final String _MSG_USE_IMPORT_STATEMENT = "import.statement.use";

    public int[] getDefaultTokens() {
        return new int[]{14, 154, 15};
    }

    @Override
    protected void doVisitToken(DetailAST detailAST) {
        DetailAST parentAST = detailAST.getParent();
        if (parentAST != null) {
            return;
        }
        List<DetailAST> nameASTList = DetailASTUtil.getAllChildTokens(detailAST, true, 58);
        for (DetailAST nameAST : nameASTList) {
            String name;
            String fullyQualifiedName = this._getFullyQualifiedName(nameAST, name = nameAST.getText());
            if (fullyQualifiedName == null || fullyQualifiedName.matches(".*\\.upgrade\\.v[0-9_]+\\.\\w+") || this._isFullyQualifiedNameRequired(detailAST, fullyQualifiedName, name, nameASTList)) continue;
            this.log(nameAST.getLineNo(), _MSG_USE_IMPORT_STATEMENT, new Object[]{fullyQualifiedName});
        }
    }

    private boolean _containsImport(DetailAST rootDetailAST, String className) {
        DetailAST siblingAST = rootDetailAST;
        while (true) {
            DetailAST dotAST;
            if ((siblingAST = siblingAST.getPreviousSibling()) == null) {
                return false;
            }
            if (siblingAST.getType() != 30 && siblingAST.getType() != 152 || (dotAST = siblingAST.findFirstToken(59)) == null) continue;
            FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)dotAST);
            String importName = fullIdent.getText();
            if (siblingAST.getType() == 30 && importName.endsWith("." + className) || siblingAST.getType() == 152 && importName.contains("." + className + ".")) break;
        }
        return true;
    }

    private String _getFullyQualifiedName(DetailAST nameAST, String name) {
        if (!name.matches("[A-Z][A-Za-z0-9]+")) {
            return null;
        }
        DetailAST parentAST = nameAST.getParent();
        if (parentAST.getType() != 59) {
            return null;
        }
        FullIdent fullIdent = FullIdent.createFullIdent((DetailAST)parentAST);
        String fullyQualifiedName = fullIdent.getText();
        if (fullyQualifiedName.matches("([a-z]\\w*\\.){2,}[A-Z]\\w*")) {
            return fullyQualifiedName;
        }
        return null;
    }

    private boolean _isFullyQualifiedNameRequired(DetailAST rootDetailAST, String fullyQualifiedName, String className, List<DetailAST> nameASTList) {
        if (this._containsImport(rootDetailAST, className)) {
            return true;
        }
        for (DetailAST nameAST : nameASTList) {
            String curFullyQualifiedName;
            String name = nameAST.getText();
            if (!name.equals(className) || (curFullyQualifiedName = this._getFullyQualifiedName(nameAST, name)) != null && curFullyQualifiedName.equals(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }
}

