/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLIvyFileCheck
extends BaseFileCheck {
    @Override
    public boolean isPortalCheck() {
        return true;
    }

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (fileName.endsWith("/ivy.xml")) {
            this._checkIvyXML(fileName, content);
        }
        return content;
    }

    private void _checkIvyXML(String fileName, String content) throws Exception {
        Document document = SourceUtil.readXML(content);
        Element rootElement = document.getRootElement();
        for (Element dependenciesElement : rootElement.elements("dependencies")) {
            String defaultconf = dependenciesElement.attributeValue("defaultconf");
            this.checkElementOrder(fileName, dependenciesElement, "dependency", defaultconf, new ElementComparator());
        }
    }
}

