/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.source.formatter.checks.BaseFileCheck;
import com.liferay.source.formatter.checks.util.JavaSourceUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtilCheck
extends BaseFileCheck {
    private final Pattern _singleLengthStringPattern = Pattern.compile("^(\".\"|StringPool\\.([A-Z_]+))$");
    private final Pattern _stringUtilReplacePattern = Pattern.compile("StringUtil\\.(replace(First|Last)?)\\((.*?)\\);\n", 32);

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) throws Exception {
        if (!absolutePath.contains("poshi")) {
            this._checkReplaceCalls(fileName, content);
        }
        return content;
    }

    private void _checkReplaceCalls(String fileName, String content) throws Exception {
        Matcher matcher = this._stringUtilReplacePattern.matcher(content);
        while (matcher.find()) {
            Field field;
            String value;
            String fieldName;
            if (ToolsUtil.isInsideQuotes(content, matcher.start())) continue;
            List<String> parametersList = JavaSourceUtil.getParameterList(matcher.group());
            if (parametersList.size() != 3) {
                return;
            }
            String secondParameter = parametersList.get(1);
            Matcher singleLengthMatcher = this._singleLengthStringPattern.matcher(secondParameter);
            if (!singleLengthMatcher.find() || (fieldName = singleLengthMatcher.group(2)) != null && (value = (String)(field = StringPool.class.getDeclaredField(fieldName)).get(null)).length() != 1) continue;
            String method = matcher.group(1);
            StringBundler sb = new StringBundler(5);
            sb.append("Use StringUtil.");
            sb.append(method);
            sb.append("(String, char, char) or StringUtil.");
            sb.append(method);
            sb.append("(String, char, String) instead");
            this.addMessage(fileName, sb.toString(), "string_methods.markdown", this.getLineCount(content, matcher.start()));
        }
    }
}

