/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.source.formatter.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checks.EmptyLinesCheck;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FTLEmptyLinesCheck
extends EmptyLinesCheck {
    private final Pattern _missingEmptyLineAfterCommentPattern = Pattern.compile("-->\n[^\n]");
    private final Pattern _missingEmptyLineBeforeCommentPattern = Pattern.compile("[^\n]\n\t*<#--");

    @Override
    protected String doProcess(String fileName, String absolutePath, String content) {
        content = this.fixEmptyLinesInMultiLineTags(content);
        content = this.fixEmptyLinesInNestedTags(content);
        content = this.fixEmptyLinesBetweenTags(content);
        content = this._fixMissingEmptyLinesAroundComments(content);
        return content;
    }

    private String _fixMissingEmptyLinesAroundComments(String content) {
        Matcher matcher = this._missingEmptyLineAfterCommentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        matcher = this._missingEmptyLineBeforeCommentPattern.matcher(content);
        if (matcher.find()) {
            return StringUtil.replaceFirst(content, "\n", "\n\n", matcher.start());
        }
        return content;
    }
}

