/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.ThreadUtil;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ClearThreadLocalUtil {
    private static final boolean _INITIALIZED;
    private static final Log _log;
    private static final Method _expungeStaleEntriesMethod;
    private static final Field _inheritableThreadLocalsField;
    private static final Method _removeMethod;
    private static final Field _tableField;
    private static final Field _threadLocalsField;
    private static final Field _valueField;

    public static void clearThreadLocal() throws Exception {
        if (!_INITIALIZED) {
            return;
        }
        Thread[] threads = ThreadUtil.getThreads();
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        for (Thread thread : threads) {
            ClearThreadLocalUtil._clearThreadLocal(thread, contextClassLoader);
        }
    }

    private static void _clearThreadLocal(Thread thread, ClassLoader classLoader) throws Exception {
        if (thread == null) {
            return;
        }
        Object threadLocalMap = _threadLocalsField.get(thread);
        Object inheritableThreadLocalMap = _inheritableThreadLocalsField.get(thread);
        ClearThreadLocalUtil._clearThreadLocalMap(threadLocalMap, classLoader);
        ClearThreadLocalUtil._clearThreadLocalMap(inheritableThreadLocalMap, classLoader);
    }

    private static void _clearThreadLocalMap(Object threadLocalMap, ClassLoader classLoader) throws Exception {
        if (threadLocalMap == null) {
            return;
        }
        Object[] table = (Object[])_tableField.get(threadLocalMap);
        if (table == null) {
            return;
        }
        int staleEntriesCount = 0;
        for (Object tableEntry : table) {
            Class<?> valueClass;
            ClassLoader valueClassLoader;
            Class<?> keyClass;
            ClassLoader keyClassLoader;
            if (tableEntry == null) continue;
            Object key = ((Reference)tableEntry).get();
            Object value = _valueField.get(tableEntry);
            boolean remove = false;
            if (key != null && (keyClassLoader = (keyClass = key.getClass()).getClassLoader()) == classLoader) {
                remove = true;
            }
            if (value != null && (valueClassLoader = (valueClass = value.getClass()).getClassLoader()) == classLoader) {
                remove = true;
            }
            if (!remove) continue;
            if (key != null) {
                if (_log.isDebugEnabled()) {
                    keyClass = key.getClass();
                    _log.debug("Clear a ThreadLocal with key of type " + keyClass.getCanonicalName());
                }
                _removeMethod.invoke(threadLocalMap, key);
                continue;
            }
            ++staleEntriesCount;
        }
        if (staleEntriesCount > 0) {
            _expungeStaleEntriesMethod.invoke(threadLocalMap, new Object[0]);
        }
    }

    static {
        Field valueField;
        Field threadLocalsField;
        Field tableField;
        Method removeMethod;
        Field inheritableThreadLocalsField;
        Method expungeStaleEntriesMethod;
        boolean initialized;
        block2: {
            _log = LogFactoryUtil.getLog(ClearThreadLocalUtil.class);
            initialized = false;
            expungeStaleEntriesMethod = null;
            inheritableThreadLocalsField = null;
            removeMethod = null;
            tableField = null;
            threadLocalsField = null;
            valueField = null;
            try {
                inheritableThreadLocalsField = ReflectionUtil.getDeclaredField(Thread.class, (String)"inheritableThreadLocals");
                threadLocalsField = ReflectionUtil.getDeclaredField(Thread.class, (String)"threadLocals");
                Class<?> threadLocalMapClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap");
                expungeStaleEntriesMethod = ReflectionUtil.getDeclaredMethod(threadLocalMapClass, (String)"expungeStaleEntries", (Class[])new Class[0]);
                removeMethod = ReflectionUtil.getDeclaredMethod(threadLocalMapClass, (String)"remove", (Class[])new Class[]{ThreadLocal.class});
                tableField = ReflectionUtil.getDeclaredField(threadLocalMapClass, (String)"table");
                Class<?> threadLocalMapEntryClass = Class.forName("java.lang.ThreadLocal$ThreadLocalMap$Entry");
                valueField = ReflectionUtil.getDeclaredField(threadLocalMapEntryClass, (String)"value");
                initialized = true;
            }
            catch (Throwable t) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Failed to initialize ClearThreadLocalUtil", t);
            }
        }
        _expungeStaleEntriesMethod = expungeStaleEntriesMethod;
        _inheritableThreadLocalsField = inheritableThreadLocalsField;
        _removeMethod = removeMethod;
        _tableField = tableField;
        _threadLocalsField = threadLocalsField;
        _valueField = valueField;
        _INITIALIZED = initialized;
    }
}

