/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.parser;

/**
 * @author Hugo Huijser
 */
public interface JavaTerm {

	public static final String ACCESS_MODIFIER_PRIVATE = "private";

	public static final String ACCESS_MODIFIER_PROTECTED = "protected";

	public static final String ACCESS_MODIFIER_PUBLIC = "public";

	public static final String[] ACCESS_MODIFIERS = {
		ACCESS_MODIFIER_PRIVATE, ACCESS_MODIFIER_PROTECTED,
		ACCESS_MODIFIER_PUBLIC
	};

	public String getAccessModifier();

	public String getContent();

	public String getName();

	public JavaClass getParentJavaClass();

	public JavaSignature getSignature();

	public boolean hasAnnotation(String annotation);

	public boolean isStatic();

	public void setParentJavaClass(JavaClass javaClass);

}