/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.parser;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringBundler;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author Hugo Huijser
 */
public class JavaSignature {

	public void addParameter(
		String parameterName, String parameterType,
		Set<String> parameterAnnotations, boolean isFinal) {

		_parameters.add(
			new JavaParameter(
				parameterName, parameterType, parameterAnnotations, isFinal));
	}

	public List<JavaParameter> getParameters() {
		return _parameters;
	}

	public String getReturnType() {
		return _returnType;
	}

	public void setReturnType(String returnType) {
		_returnType = returnType;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(_parameters.size() * 2 + 1);

		sb.append(CharPool.OPEN_PARENTHESIS);

		for (JavaParameter parameter : _parameters) {
			sb.append(parameter.getParameterType());
			sb.append(CharPool.COMMA);
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append(CharPool.CLOSE_PARENTHESIS);

		return sb.toString();
	}

	private final List<JavaParameter> _parameters = new ArrayList<>();
	private String _returnType;

}