/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.util;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.source.formatter.SourceFormatterMessage;
import com.liferay.source.formatter.util.CheckType;

import com.puppycrawl.tools.checkstyle.DefaultLogger;
import com.puppycrawl.tools.checkstyle.api.AuditEvent;

import java.io.OutputStream;

import java.nio.file.Path;
import java.nio.file.Paths;

import java.util.Set;
import java.util.TreeSet;

/**
 * @author Hugo Huijser
 */
public class CheckstyleLogger extends DefaultLogger {

	public CheckstyleLogger(
		OutputStream outputStream, boolean closeStreamsAfterUse,
		String baseDirName) {

		super(outputStream, closeStreamsAfterUse);

		_baseDirName = baseDirName;

		_sourceFormatterMessages.clear();
	}

	@Override
	public void addError(AuditEvent auditEvent) {
		String sourceName = StringUtil.extractLast(
			auditEvent.getSourceName(), CharPool.PERIOD);

		_sourceFormatterMessages.add(
			new SourceFormatterMessage(
				_getRelativizedFileName(auditEvent), auditEvent.getMessage(),
				CheckType.CHECKSTYLE, sourceName, null, auditEvent.getLine()));

		super.addError(auditEvent);
	}

	public Set<SourceFormatterMessage> getSourceFormatterMessages() {
		return _sourceFormatterMessages;
	}

	private Path _getAbsoluteNormalizedPath(String pathName) {
		Path path = Paths.get(pathName);

		path = path.toAbsolutePath();

		return path.normalize();
	}

	private String _getRelativizedFileName(AuditEvent auditEvent) {
		if (Validator.isNull(_baseDirName)) {
			return auditEvent.getFileName();
		}

		Path baseDirPath = _getAbsoluteNormalizedPath(_baseDirName);

		Path relativizedPath = baseDirPath.relativize(
			_getAbsoluteNormalizedPath(auditEvent.getFileName()));

		return _baseDirName +
			StringUtil.replace(
				relativizedPath.toString(), CharPool.BACK_SLASH,
				CharPool.SLASH);
	}

	private static final Set<SourceFormatterMessage> _sourceFormatterMessages =
		new TreeSet<>();

	private final String _baseDirName;

}