/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

/**
 * @author Hugo Huijser
 */
public class TernaryOperatorCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.QUESTION};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		if (DetailASTUtil.getStartLine(detailAST) !=
				DetailASTUtil.getEndLine(detailAST)) {

			log(detailAST.getLineNo(), _MSG_AVOID_TERNARY_OPERATOR);
		}
	}

	private static final String _MSG_AVOID_TERNARY_OPERATOR =
		"ternary.operator.avoid";

}