/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtils;

import java.util.List;

/**
 * @author Hugo Huijser
 */
public class LocalPatternCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.VARIABLE_DEF};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		if (!ScopeUtils.isLocalVariableDef(detailAST)) {
			return;
		}

		List<DetailAST> methodCallASTList = DetailASTUtil.getMethodCalls(
			detailAST, "Pattern", "compile");

		if (methodCallASTList.isEmpty()) {
			return;
		}

		DetailAST methodCallAST = methodCallASTList.get(0);

		DetailAST elistAST = methodCallAST.findFirstToken(TokenTypes.ELIST);

		DetailAST expressionAST = elistAST.findFirstToken(TokenTypes.EXPR);

		List<DetailAST> childASTList = DetailASTUtil.getAllChildTokens(
			expressionAST, true, DetailASTUtil.ALL_TYPES);

		for (DetailAST childAST : childASTList) {
			if ((childAST.getType() != TokenTypes.PLUS) &&
				(childAST.getType() != TokenTypes.STRING_LITERAL)) {

				return;
			}
		}

		DetailAST nameAST = detailAST.findFirstToken(TokenTypes.IDENT);

		log(detailAST.getLineNo(), _MSG_LOCAL_PATTERN, nameAST.getText());
	}

	private static final String _MSG_LOCAL_PATTERN = "pattern.local";

}