/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

/**
 * @author Hugo Huijser
 */
public class LineBreakAfterCommaCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.COMMA};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST parentAST = detailAST.getParent();

		if (parentAST.getType() != TokenTypes.ELIST) {
			return;
		}

		String line = getLine(detailAST.getLineNo() - 1);

		if ((detailAST.getColumnNo() + 1) == line.length()) {
			return;
		}

		DetailAST previousSiblingAST = detailAST.getPreviousSibling();

		if (detailAST.getLineNo() !=
				DetailASTUtil.getStartLine(previousSiblingAST)) {

			String s = StringUtil.trim(
				line.substring(0, detailAST.getColumnNo() + 1));

			log(detailAST.getLineNo(), _MSG_INCORRECT_LINE_BREAK, s);
		}
	}

	private static final String _MSG_INCORRECT_LINE_BREAK =
		"line.break.incorrect";

}