/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checkstyle.checks;

import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.source.formatter.checkstyle.util.DetailASTUtil;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TokenTypes;

/**
 * @author Hugo Huijser
 */
public class InstanceofOrderCheck extends BaseCheck {

	@Override
	public int[] getDefaultTokens() {
		return new int[] {TokenTypes.LITERAL_INSTANCEOF};
	}

	@Override
	protected void doVisitToken(DetailAST detailAST) {
		DetailAST parentAST = detailAST.getParent();

		if ((parentAST.getType() != TokenTypes.LAND) &&
			(parentAST.getType() != TokenTypes.LOR)) {

			return;
		}

		DetailAST nextConditionAST = _getNextConditionAST(detailAST);

		if ((nextConditionAST == null) ||
			(nextConditionAST.getType() != TokenTypes.LITERAL_INSTANCEOF)) {

			return;
		}

		String variableName1 = _getVariableName(detailAST);
		String variableName2 = _getVariableName(nextConditionAST);

		if ((variableName1 == null) || !variableName1.equals(variableName2)) {
			return;
		}

		NaturalOrderStringComparator comparator =
			new NaturalOrderStringComparator();

		String typeName1 = DetailASTUtil.getTypeName(detailAST);
		String typeName2 = DetailASTUtil.getTypeName(nextConditionAST);

		if (comparator.compare(typeName1, typeName2) > 0) {
			log(
				nextConditionAST.getLineNo(), _MSG_ORDER_INSTANCEOF, typeName2,
				typeName1);
		}
	}

	private DetailAST _getNextConditionAST(DetailAST detailAST) {
		DetailAST nextSibling = detailAST.getNextSibling();

		if (nextSibling != null) {
			return nextSibling;
		}

		DetailAST parentAST = detailAST.getParent();

		return parentAST.getNextSibling();
	}

	private String _getVariableName(DetailAST literalInstanceOfAST) {
		DetailAST nameAST = literalInstanceOfAST.findFirstToken(
			TokenTypes.IDENT);

		if (nameAST == null) {
			return null;
		}

		return nameAST.getText();
	}

	private static final String _MSG_ORDER_INSTANCEOF = "instanceof.order";

}