/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks.configuration;

import com.liferay.source.formatter.util.CheckType;

import com.puppycrawl.tools.checkstyle.api.FilterSet;
import com.puppycrawl.tools.checkstyle.filters.SuppressElement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Hugo Huijser
 */
public class SourceFormatterSuppressions {

	public void addSuppression(
		CheckType checkType, String suppressionsFileLocation, String checkName,
		String fileName) {

		if (checkType.equals(CheckType.SOURCE_CHECK)) {
			_addSourceCheckSuppression(
				suppressionsFileLocation, checkName, fileName);
		}
		else {
			_addCheckstyleSuppression(checkName, fileName);
		}
	}

	public FilterSet getCheckstyleFilterSet() {
		return _checkstyleFilterSet;
	}

	public boolean isSuppressed(String sourceCheckName, String absolutePath) {
		Map<String, List<String>> sourceCheckSuppressionsMap =
			_sourceChecksSuppressionsMap.get(sourceCheckName);

		if (sourceCheckSuppressionsMap == null) {
			return false;
		}

		for (Map.Entry<String, List<String>> entry :
				sourceCheckSuppressionsMap.entrySet()) {

			String suppressionsFileLocation = entry.getKey();

			if (!absolutePath.startsWith(suppressionsFileLocation)) {
				continue;
			}

			List<String> fileNames = entry.getValue();

			for (String fileName : fileNames) {
				if (absolutePath.matches(".*" + fileName)) {
					return true;
				}
			}
		}

		return false;
	}

	private void _addCheckstyleSuppression(String checkName, String fileName) {
		_checkstyleFilterSet.addFilter(
			new SuppressElement(fileName, checkName, null, null, null));
	}

	private void _addSourceCheckSuppression(
		String suppressionsFileLocation, String checkName, String fileName) {

		Map<String, List<String>> sourceCheckSuppressionsMap =
			_sourceChecksSuppressionsMap.get(checkName);

		if (sourceCheckSuppressionsMap == null) {
			sourceCheckSuppressionsMap = new HashMap<>();
		}

		List<String> fileNames = sourceCheckSuppressionsMap.get(
			suppressionsFileLocation);

		if (fileNames == null) {
			fileNames = new ArrayList<>();
		}

		fileNames.add(fileName);

		sourceCheckSuppressionsMap.put(suppressionsFileLocation, fileNames);

		_sourceChecksSuppressionsMap.put(checkName, sourceCheckSuppressionsMap);
	}

	private final FilterSet _checkstyleFilterSet = new FilterSet();
	private final Map<String, Map<String, List<String>>>
		_sourceChecksSuppressionsMap = new HashMap<>();

}