/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.source.formatter.checks.comparator.ElementComparator;
import com.liferay.source.formatter.checks.util.SourceUtil;

import org.dom4j.Document;
import org.dom4j.Element;

/**
 * @author Hugo Huijser
 */
public class XMLSuppressionsFileCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws Exception {

		if (!fileName.endsWith("-suppressions.xml")) {
			return content;
		}

		Document document = SourceUtil.readXML(content);

		Element rootElement = document.getRootElement();

		SuppressElementComparator suppressElementComparator =
			new SuppressElementComparator();

		checkElementOrder(
			fileName, rootElement, "suppress", null, suppressElementComparator);

		checkElementOrder(
			fileName, rootElement.element("checkstyle"), "suppress",
			"checkstyle", suppressElementComparator);
		checkElementOrder(
			fileName, rootElement.element("source-check"), "suppress",
			"source-check", suppressElementComparator);

		return content;
	}

	private class SuppressElementComparator extends ElementComparator {

		@Override
		public String getElementName(Element suppressElement) {
			StringBundler sb = new StringBundler(3);

			sb.append(suppressElement.attributeValue("checks"));
			sb.append(StringPool.POUND);
			sb.append(suppressElement.attributeValue("files"));

			return sb.toString();
		}

	}

}