/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

/**
 * @author Hugo Huijser
 */
public class SQLEmptyLinesCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		String[] lines = StringUtil.splitLines(content);

		for (int i = 1; i < lines.length; i++) {
			String line = lines[i];
			String previousLine = lines[i - 1];

			if (Validator.isNull(line) || line.startsWith("\t") ||
				Validator.isNull(previousLine) ||
				previousLine.startsWith("\t")) {

				continue;
			}

			String previousSQLCommand = _getSQLCommand(previousLine);
			String sqlCommand = _getSQLCommand(line);

			if (!previousSQLCommand.equals(sqlCommand)) {
				return StringUtil.replace(
					content, previousLine + "\n" + line,
					previousLine + "\n\n" + line);
			}
		}

		return content;
	}

	private String _getSQLCommand(String line) {
		String[] words = StringUtil.split(line, CharPool.SPACE);

		return words[0];
	}

}