/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

/**
 * @author Peter Shin
 */
public class PropertiesSourceFormatterContentCheck extends BaseFileCheck {

	@Override
	protected String doProcess(
			String fileName, String absolutePath, String content)
		throws Exception {

		if (fileName.endsWith("/source-formatter.properties")) {
			content = _checkConvertedKeys(content);
			content = _checkGitLiferayPortalBranch(content);
		}

		return content;
	}

	private String _checkConvertedKeys(String content) {
		for (String[] array : _CONVERTED_KEYS) {
			content = StringUtil.replace(content, array[0], array[1]);
		}

		return content;
	}

	private String _checkGitLiferayPortalBranch(String content) {
		if (!content.matches("(?s).*[^#]git\\.liferay\\.portal\\.branch=.*")) {
			return content;
		}

		String gitLiferayPortalBranch = StringPool.BLANK;
		String previousLine = StringPool.BLANK;

		String[] lines = StringUtil.splitLines(content);

		StringBundler sb = new StringBundler(lines.length * 2);

		for (String line : lines) {
			String trimmedLine = StringUtil.trim(line);

			if (trimmedLine.startsWith("git.liferay.portal.branch=")) {
				gitLiferayPortalBranch = trimmedLine.substring(
					trimmedLine.indexOf(CharPool.EQUAL) + 1);
			}

			String s = StringUtil.trim(previousLine);

			if (s.equals("git.liferay.portal.branch=\\")) {
				gitLiferayPortalBranch = StringUtil.trim(line);
			}
			else if (!trimmedLine.startsWith("git.liferay.portal.branch=")) {
				sb.append(line);
				sb.append("\n");
			}

			previousLine = line;
		}

		String exclusionsComments = StringBundler.concat(
			"##\n## Exclusions\n##\n## See ", _SOURCE_FORMATTER_PROPERTIES_URL,
			"\n## for available properties.\n##");
		String gitComments = "##\n## Git\n##";

		String s = StringUtil.replace(
			sb.toString(), new String[] {exclusionsComments, gitComments},
			new String[] {StringPool.BLANK, StringPool.BLANK});

		s = StringUtil.trim(s);

		if (Validator.isNull(s)) {
			return StringBundler.concat(
				exclusionsComments, "\n\n", gitComments, "\n\n",
				StringPool.FOUR_SPACES, "git.liferay.portal.branch=",
				gitLiferayPortalBranch);
		}

		return StringBundler.concat(
			exclusionsComments, "\n\n", StringPool.FOUR_SPACES, s, "\n\n",
			gitComments, "\n\n", StringPool.FOUR_SPACES,
			"git.liferay.portal.branch=", gitLiferayPortalBranch);
	}

	private static final String[][] _CONVERTED_KEYS = {
		new String[] {
			"blob/master/portal-impl/src/source-formatter.properties",
			"blob/master/source-formatter.properties"
		}
	};

	private static final String _SOURCE_FORMATTER_PROPERTIES_URL =
		"https://github.com/liferay/liferay-portal/blob/master" +
			"/source-formatter.properties";

}