/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.source.formatter.checks;

/**
 * @author Hugo Huijser
 * @author Peter Shin
 */
public class JavaUnsafeCastingCheck extends BaseFileCheck {

	@Override
	public boolean isPortalCheck() {
		return true;
	}

	@Override
	protected String doProcess(
		String fileName, String absolutePath, String content) {

		for (String unsafeClassName : _UNSAFE_CLASS_NAMES) {
			int pos = -1;

			while (true) {
				pos = content.indexOf("(" + unsafeClassName + ")", pos + 1);

				if (pos == -1) {
					break;
				}

				String message = "Unsafe casting for '" + unsafeClassName + "'";

				addMessage(
					fileName, message, "unsafe_casting.markdown",
					getLineCount(content, pos));
			}
		}

		return content;
	}

	private static final String[] _UNSAFE_CLASS_NAMES =
		{"LiferayPortletRequest", "LiferayPortletResponse"};

}